/*
 * Copyright (C) 2000 - 2024 Silverpeas
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * As a special exception to the terms and conditions of version 3.0 of
 * the GPL, you may redistribute this Program in connection with Free/Libre
 * Open Source Software ("FLOSS") applications as described in Silverpeas's
 * FLOSS exception.  You should have received a copy of the text describing
 * the FLOSS exception, and it is also available here:
 * "https://www.silverpeas.org/legal/floss_exception.html"
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
/**
 * The Scheduling Engine in Silverpeas provides an API to get either a volatile or a persistent
 * scheduler. The first one is for scheduling volatile jobs in the time, jobs that will be
 * discarded at each VM restarting. The last one is for scheduling persistent jobs, meaning the
 * scheduled jobs are serialized into a persistence context so that they can be restored at each
 * VM restarting. Both are built atop of an existing scheduling system and the Scheduling Engine
 * encapsulates it.
 */
package org.silverpeas.core.scheduler;
